Date: Fri, 24 Aug 2001 10:02:16 -0400 (EDT)
From: Stan Brown <support@oakroadsystems.com>


=====================================================================
# pcre_msc.mak
# Makefile for Microsoft MSVC/C++ 5.0 using command-line tools only.
# (This may also work with later versions than 5.0; I don't know.)
#
# author: Stan Brown, Oak Road Systems, http://oakroadsystems.com/
# revision date: 2001-08-23
#
# This file started from the file by Paul Whitehead at
#    ftp://ftp.csx.cam.ac.uk/pub/software/programming/pcre/Contrib/win32.mak
# dated 2001-04-04 but was edited substantially. The main differences:
#
# 1. Change from Borland to MSVC++ syntax, specifically for MSVC++ 5.0. (This
#    might work with later versions too, but I haven't tried it.)
#
# 2. Make dependencies and command sequence match those in the PCRE supplied
#    NON_UNIX_USE file.
#
# 3. Distinguish between 'clean' and 'distclean' as the PCRE makefile does.
#
# 4. Add a 'runtest' target to run the tests. This assumes the DOS comparison
#    program FC is in the path, but the identity and location of the compare
#    program can be changed in the macro DIFF, (newly) defined below.
#
# 5. Update the dependency lists, and add a target for pcregrep.exe (though it's
#    not built as part of the default 'all' target).
#
# This file is made available under the same 'open source' policy as PCRE.

# Please note: you will need to edit the "config.in" and "pcre.in" files as per
# the NON-UNIX-USE instructions included with PCRE before using this makefile.
# This is because Win32 systems do not come with 'sed' as a standard tool :-(
# For this reason, the "clean" target will NOT remove either config.h or pcre.h

# Before using this file, check the definition of MSC_INST_DIR below, and change
# it if necessary.
#
# Syntax for use with MSVC++'s nmake:
#    nmake -f win32.mak [target]
# target = all or (omitted) to build and stop
#          runtest          to run tests 1-4 (5-5 require UTF-8 support)
#          test1, ... test6 to  run just that one test
#          clean            to delete all built products
#          distclean        to delete all built products and return to a
#                               virgin distribution
# This file builds static libraries (.lib), not DLLs.

# Five warning messages are expected during the build, as follows:
# pcreposix.c(254) : warning C4018: '<' : signed/unsigned mismatch
#    This one is from a for loop with int index variable and size_t limit.
#    No potential problem.
# pcretest.c(708) : warning C4056: overflow in floating-point constant arithmetic
# pcretest.c(843) : warning C4056: overflow in floating-point constant arithmetic
# pcretest.c(1095) : warning C4056: overflow in floating-point constant arithmetic
#    These three come from multiplying LOOPREPEAT (20000) by CLOCKS_PER_SEC.
#    Presumably the overflow causes the timing values to be wrong in the output
#    of pcretest.
# pcretest.c(1057) : warning C4018: '<' : signed/unsigned mismatch
#    This one is from a for loop with size_t index variable and int limit.
#    I believe there is no potential problem.


MSC_INST_DIR=c:\progra~1\devstudio\vc
CC=$(MSC_INST_DIR)\bin\cl.exe
LIBEXE=$(MSC_INST_DIR)\bin\lib.exe
CPPFLAGS=/DSTATIC /Za /W3 /GX /ML /Ob2 /nologo
LINKFLAGS=

DIFF=fc

.c.obj:
    $(CC) $(CPPFLAGS) -c $<

# first target - this will get run by default if no target specified
all: pcre.lib pcreposix.lib dftables.exe pcretest.exe

pcre.lib: get.obj maketables.obj pcre.obj study.obj
    @echo. >$(*B).inp
    @if exist $@ echo $@ >>$(*B).inp
    @!echo $? >>$(*B).inp
    $(LIBEXE) /out:$@ /verbose /nologo @$(*B).inp
    $(LIBEXE) /list:$(*B).lst /verbose /nologo $@

pcreposix.lib: pcreposix.obj
    @echo. >$(*B).inp
    @if exist $@ echo $@ >>$(*B).inp
    @!echo $? >>$(*B).inp
    $(LIBEXE) /out:$@ /verbose /nologo @$(*B).inp
    $(LIBEXE) /list:$(*B).lst /verbose /nologo $@

dftables.exe: dftables.obj
    $(CC) $(CPPFLAGS) $(LINKFLAGS) dftables.c

chartables.c : dftables.exe
    dftables.exe > chartables.c

pcregrep.exe: pcre.lib pcregrep.obj
    $(CC) $(CPPFLAGS) $(LINKFLAGS) pcregrep.obj pcre.lib

pcretest.exe: pcre.lib pcreposix.lib pcretest.obj
    $(CC) $(CPPFLAGS) $(LINKFLAGS) pcretest.obj pcre.lib pcreposix.lib

# We deliberately omit dftables and chartables.c from "make ... clean"; once
# made chartables.c shouldn't change, and if people have edited the tables by
# hand, you don't want to throw them away.
# But "nmake ... distclean" should get back to a virgin distribution

clean:
    @if exist get.obj del get.obj
    @if exist maketables.obj del maketables.obj
    @if exist pcre.obj del pcre.obj
    @if exist study.obj del study.obj
    @if exist pcre.lib del pcre.lib
    @if exist pcreposix.obj del pcreposix.obj
    @if exist pcreposix.lib del pcreposix.lib
    @if exist pcregrep.obj del pcregrep.obj
    @if exist pcregrep.exe del pcregrep.exe
    @if exist pcretest.obj del pcretest.obj
    @if exist pcretest.exe del pcretest.exe
    @if exist testtry del testtry
# .lst files are list files showing the contents of the static libraries
# .inp files are command files created and used in building libraries
# Both sets will be re-generated if required.
    @if exist pcreposix.lst del pcreposix.lst
    @if exist pcreposix.inp del pcreposix.inp
    @if exist pcre.lst del pcre.lst
    @if exist pcre.inp del pcre.inp

distclean : clean
    @if exist chartables.c del chartables.c
    @if exist dftables.obj del dftables.obj
    @if exist dftables.exe del dftables.exe
    @if exist pcre.h del pcre.h
    @if exist config.h del config.h


dftables.obj: config.h internal.h pcre.h dftables.c maketables.c
get.obj: config.h internal.h pcre.h get.c
maketables.obj: config.h internal.h pcre.h maketables.c
pcre.obj: config.h internal.h pcre.h pcre.c chartables.c
pcregrep.obj: config.h pcre.h pcregrep.c
pcreposix.obj: config.h internal.h pcre.h pcreposix.h pcreposix.c
pcretest.obj: config.h internal.h pcre.h pcreposix.h pcretest.c
study.obj: config.h internal.h pcre.h study.c

runtest : test1 test2 test3 test4 # test5 test6
    @echo All tests have been run.

test1 : pcretest.exe
    @echo Testing main functionality (Perl compatible)
    pcretest testdata\testinput1 testtry
    $(DIFF) testdata\testoutput1 testtry

test2 : pcretest.exe
    @echo Testing API and error handling (not Perl compatible)
    pcretest -i testdata\testinput2 testtry
    $(DIFF) testdata\testoutput2 testtry

test3 : pcretest.exe
    @echo Testing Perl 5.005 features (Perl 5.005 compatible)
    pcretest testdata\testinput3 testtry
    $(DIFF) testdata\testoutput3 testtry

test4 : pcretest.exe
    @echo Testing locale-specific features (using 'fr' locale)
    @echo If this test does not run entirely successfully,
    @echo it usually means that there is a problem with the locale
    @echo settings rather than a bug in PCRE.
    pcretest testdata\testinput4 testtry
    $(DIFF) testdata\testoutput4 testtry

test5 : pcretest.exe
    @echo Testing experimental, incomplete UTF8 support (Perl compatible)
    pcretest testdata\testinput5 >testtry
    $(DIFF) testdata\testoutput5 testtry

test6 : pcretest.exe
    @echo Testing API and internals for UTF8 support (not Perl compatible)
    pcretest testdata\testinput6 >testtry
    $(DIFF) testdata\testoutput6 testtry
=====================================================================
